﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="Manufacturers.aspx.cs" Inherits="PirTickets.Manufacturers" ViewStateEncryptionMode="Never"  %>

<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <script type="text/javascript">
        function BeforeClientDelete(record) {
            if (confirm("Are you sure you want to remove " + record.manufacturer +"?") == false) {
                return false;
            }
            return true;
        }

        function BeforeClientDeleteModel(record) {
            if (confirm("Are you sure you want to remove " + record.ModelName + "?") == false) {
                return false;
            }
            return true;
        }
    </script>

    <h2>Manufacturers</h2>

        <h4>Add New Manufacturer</h4>
        <asp:TextBox ID="TxtAdd" runat="server" MaxLength="50" Width="220px"></asp:TextBox>
        <asp:Button ID="badd" runat="server" onclick="badd_Click" Text="Add New" />
        <asp:Label ID="lblAlert" runat="server"></asp:Label>

        <cc1:Grid ID="gridManufacturers" runat="server" AllowPaging="True" AllowSorting="False" AutoGenerateColumns="false"
            datakeynames="id" Width="800px" DataSourceID="SqlDataManufacturers" OnSelect="gridManufacturers_Select" AllowAddingRecords="False"
            AutoPostBackOnSelect="true" AllowFiltering="false" OnDeleteCommand="gridManufacturers_DeleteCommand" OnUpdateCommand="gridManufacturers_UpdateCommand"
            FolderStyle="~/Styles/style_5"
            AllowGrouping="False" AllowRecordSelection="true" Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100">
            <ClientSideEvents OnBeforeClientDelete ="BeforeClientDelete"  />
            <columns>              
              
                <cc1:Column AllowEdit="true" AllowDelete="false" HeaderText="" Width="75px" runat="server" Index="0" />
                <cc1:Column AllowEdit="false" AllowDelete="true" HeaderText="" Width="75px" runat="server" Index="1" />
                <cc1:Column DataField="id" HeaderText="Id" Index="2" ReadOnly="True" Width="5px" Visible="false"></cc1:Column>
                <cc1:Column DataField="manufacturer" HeaderText="manufacturer" Index="3" Width="600px"  ></cc1:Column>
             </columns>
         </cc1:Grid>

        <asp:SqlDataSource ID="SqlDataSourceRTMContacts" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
            SelectCommand="select id, firstname +' ' + surname + ', ' + street + ' ' + town + ' ' + county as contact from vwcontacts"></asp:SqlDataSource>
        
        <asp:SqlDataSource ID="SqlDataManufacturers" runat="server"  ConnectionString="<%$ ConnectionStrings:PirTickets %>" 
            SelectCommand="SELECT [id], [manufacturer],RTMContact FROM [Manufacturers] order by [manufacturer]" >
        </asp:SqlDataSource>
        <br />
        <h4>Add New Model to Manufacturer</h4>
        <asp:TextBox ID="txtAddModel" runat="server" MaxLength="50" Width="220px"></asp:TextBox>
        <asp:Button ID="btAddModel" runat="server" onclick="baddModel_Click" Text="Add New" />
        <asp:Label ID="lblModel" runat="server"></asp:Label>
        <br />
        <cc1:Grid ID="gridModels" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="modelid"
            Width="800px" DataSourceID="SqlDataModels" AllowAddingRecords="False"
            AutoPostBackOnSelect="true" AllowFiltering="True" OnDeleteCommand="gridModels_DeleteCommand" OnUpdateCommand="gridModels_UpdateCommand" FolderStyle="~/Styles/style_5"
            AllowGrouping="False" AllowRecordSelection="true" Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100">
            <ClientSideEvents OnBeforeClientDelete="BeforeClientDeleteModel" />
            <Columns>
                <cc1:Column DataField="modelid" HeaderText="Id" InsertVisible="False" Visible="false" Index="0" ReadOnly="True" SortExpression="modelid" Width="50px"></cc1:Column>
                <cc1:Column ID="Column1" AllowEdit="true" AllowDelete="false" HeaderText="" Width="75px" runat="server" Index="1" />
                <cc1:Column ID="Column2" AllowEdit="false" AllowDelete="true" HeaderText="" Width="75px" runat="server" Index="2" />
                <cc1:Column DataField="ModelName" HeaderText="Model Name" Index="3" SortExpression="ModelName" Width="600px">
                </cc1:Column>
            </Columns>
        </cc1:Grid>

        <asp:SqlDataSource ID="SqlDataModels" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>" 
            SelectCommand="SELECT [modelid], [ModelName] FROM [Models] WHERE ([manufacturerID] = @manufacturerID)" >
            <SelectParameters>
                <asp:Parameter  Name="manufacturerID" Type="Int32" />
            </SelectParameters>
        </asp:SqlDataSource>

        <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="updatepanel2">
        </asp:UpdateProgress>
    
</asp:Content>
